﻿using System.Collections.Generic;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using MyFirstApp.Server.Services;
using MyFirstApp.Shared;

namespace MyFirstApp.Server.Controllers
{  

    [ApiController]
    [Route("[controller]")]
    public class UserController : ControllerBase
    {
        private UserService _userService;
        private IEnumerable<User> _users;

        public UserController(UserService userService)
        {
            _userService = userService;            
        }

        [HttpGet]
        public async Task<IEnumerable<User>> Get()
        {
            _users = await _userService.Get();
            return _users;
        }

        [HttpDelete]
        [Route("/{id}")]
        public async Task<string> Delete(string id)
        {
            return await _userService.Delete(id);
        }

        [HttpPut]
        [Route("/{id}")]
        public async Task Update([FromBody] User userTemp)
        {
            await _userService.Update(userTemp);
        }
    }
}
